/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_irecv.c,v 1.13 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t
mx_irecv(mx_endpoint_t endpoint,
         mx_segment_t *segments_list,
         uint32_t segments_count,
	 uint64_t match_info,
	 uint64_t match_mask,
         void *context,
         mx_request_t *request)
{
    return (mx_irecv_with_type(endpoint, segments_list, segments_count,
                               match_info, match_mask,
                               context, request,
                               MX_SR_TYPE_SEND));
}

mx_return_t
mx_irecv_with_type(mx_endpoint_t endpoint,
                   mx_segment_t *segments_list,
                   uint32_t segments_count,
		   uint64_t match_info,
		   uint64_t match_mask,
                   void *context,
                   mx_request_t *request,
                   mx_sr_type_t type)
{
    struct mx_endpoint *pp;
    struct mx_lib_recv *recv;
    struct mx_post *post;
    int matched;

    pthread_mutex_lock(&Mx_rx_lock);
    pp = (struct mx_endpoint *)endpoint;
    
    /* get a post record */
    post = mx_new_post(pp, MX_POST_TYPE_RECV, context);
    recv = &(post->ts.recv);
    
    /* fill in recv fields */
    recv->length = mx_segment_list_len(segments_list, segments_count);
    recv->seg_list = mx_new_segment_list(segments_list, segments_count);
    recv->seg_cnt = segments_count;
    recv->match_info = match_info;
    recv->match_mask = match_mask;
    recv->type = type;
    
    /* try to match with queue of unexpected messages */
    matched = mx_match_queued_message(post, type);
    
    /* if no match, put this on endpoints active receive list at the end */
    if (!matched) {
        MX_LIST_INSERT(&pp->recv_list, post);
        MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("recv on 0x%08x%08x:0x%08x%08x now pending\n", MX_U32(match_info),
                  MX_L32(match_info), MX_U32(match_mask), MX_L32(match_mask)));
    }
    
    /* run asynch I/O once for good measure */
    /*mx_run_asynch_io(pp, 0);*/
    
    /* return this handle */
    if (request != NULL) {
        *request = (mx_request_t)post;
    }
    pthread_mutex_unlock(&Mx_rx_lock);
    return MX_SUCCESS;
}
